'MIDI Mate by Dan Amos
'Licenses under Attribution-NonCommercial-ShareAlike 3.0 Australia license
'http://creativecommons.org/licenses/by-nc-sa/3.0/au/

Dim nt$(11)=( "A","A#","B","C","C#","D","D#","E","F","F#","G","G#" )
Dim mt$(15)=( "A","B","C","D","7","8","9","E","4","5","6","F","1","2","3","0")
Dim whiteNote(7)=(0,2,4,5,7,9,11,12)
Dim btcol%(23,3)
Dim bttxt$(23,3)
Dim seq$(3)
Dim laychan(3)
Dim empty(3) 'layer is empty
Dim seqlength = 0
Dim settings$
Dim win = 0 'window in use
Dim lcdy = 0 'analyser line position
Dim lcdind = 0 'analyser colour index
Dim col% = RGB(white)
Dim selected = -1 'selected button
Dim bc = 0
Dim channel = 1
Dim velocity = 127
Dim layer = 0
Dim arp = 0 'arpeggiator 0=off, 1=123,2 = 132,3=213,4=231,5=312,6=321
Dim vp = 0 'velocity profile 0=flat, 1 = fast, 2 = slow
Dim sel = 0 'selected note in sequencer
Dim play = 0 '0 = stopped, 1 = playing
Dim more = 0 '0 = initial layout, 2= more
Dim lastplayed = 0 'last note played

Initialize

Do
  CLS
  Box 0,0,240,160,2,RGB(black),RGB(blue)
  Text 120,80,"Analyser",CM,1,2,RGB(white),RGB(blue)
  Box 240,0,240,160,2,RGB(black),RGB(red)
  Text 360,80,"MIDI Commands",CM,1,2,RGB(white),RGB(red)
  Box 0,160,240,160,2,RGB(black),RGB(green)
  Text 120,240,"Sequencer",CM,1,2,RGB(black),RGB(green)
  Box 240,160,240,160,2,RGB(black),RGB(yellow)
  Text 360,240,"Keyboard",CM,1,2,RGB(black),RGB(yellow)
  Do
    x = Touch(x)
    y = Touch(y)
  Loop Until x>=0
  CLS
  waittouchup
  If x<240 Then
    If y > 160 Then
      MidiSeq
    Else
      Analyse
    EndIf
  Else
    If y > 160 Then
      Keyboard
    Else
      Midibuttons
    EndIf
  EndIf
Loop
End

Sub Initialize
VAR restore
SetPin 4,dout 'PWM1A - audio
SetPin 9,dout 'gate out
SetPin 10,dout 'trigger out
SetPin 26,dout 'PWM2A - oct/volt
Pin(26)=1
If btcol%(0,0) = 0 Then
For i = 0 To 5
  r=(i Mod 3)*30+195
  g=(i\3 Mod 2)*128+127
  btcol%(i,1)=RGB(r,g,0)
  btcol%(i+6,1)=RGB(r,0,g)
  btcol%(i+12,1)=RGB(0,r,g)
  btcol%(i+18,1)=RGB(r,r,g)
Next i
For i = 0 To 23
  If i Mod 6 = 0 Then
    btcol%(i,0) = RGB(180,180,180)
  Else
    btcol%(i,0) = RGB(white)
  EndIf
  If (i Mod 6 < 4) Then
    btcol%(i,2) = RGB(white)
  Else
    btcol%(i,2) = RGB(black)
  EndIf
  bttxt$(i,0) = ""
Next i
EndIf
For i = 0 To 23
  If (i Mod 6 < 4) Then
    bttxt$(i,2) = mt$((i\6)*4+(i Mod 6))
  EndIf
Next i
bttxt$(23,2) = "SAVE":btcol%(23,2) = RGB(red)
bttxt$(22,2) = "BACK":btcol%(22,2) = RGB(green)
a$ = ""
If Len(seq$(0)) = 0 Then
  For i = 1 To 192
    a$ = a$ + Chr$(1)
  Next i
  seq$(0)=a$
  seq$(1)=a$
  seq$(2)=a$
  seqlength = 0
  laychan(0)=1
  laychan(1)=2
  laychan(2)=3
EndIf
Open "COM1:31250" As #1
End Sub

Sub Analyse
Local f=0
Do
If Loc(#1) > 0 Then
  d$=Input$(1,#1)
  MidiOut d$
  a$ = Hex$(Asc(d$),2)
  i = Asc(d$) >> 4
  ch = Asc(d$) And &hf
  If i = 15 Then
    'filter system message
  Else
    d$=Input$(1,#1)
    MidiOut d$
    j = Asc(d$)
    a$ = a$ + Hex$(j,2)
    If i = 8 Or i = 9 Or i = 10 Or i = 11 Or i = 14 Or i = 15 Then
      d$ = Input$(1,#1)
      MidiOut d$
      k = Asc(d$)
      a$ = a$ + Hex$(k,2)
    End If
    f = k * 128 + j
    a$ = a$ + " ch" + Str$(ch) + ":"
    Select Case i
    Case 8
      a$ = a$ + "Note off " + GetNote$(j) + " " + Str$(k)
      If lastplayed = j Then
        Pin(9)=1
        PWM 1,440,0
      EndIf
    Case 9
      If k = 0 Then
        If lastplayed = j Then
          PWM 1,440,0
          Pin(9)=1
        EndIf
        a$ = a$ + "Note off " + GetNote$(j) + " " + Str$(k)
      Else
        lastplayed = j
        f = 2^((j-49)/12)*440
        PWM 1,f,50
        updateanalog j
        a$ = a$ + "Note on " + GetNote$(j) + " " + Str$(k)
      EndIf
    Case 10
      a$ = a$ + "Aft Tch " + GetNote$(j) + " " + Str$(k)
    Case 11
      a$ = a$ + "Cont Chg " + Str$(j) + " to " + Str$(k)
    Case 12
      a$ = a$ + "Patch " + Str$(j)
    Case 13
      a$ = a$ + "Ch Aft " + Str$(j)
    Case 14
      a$ = a$ + "Pitch " + Str$(f)
    Case 15
      a$ = a$ + "Ch Msg " + Str$(j) + " to " + Str$(k)
    End Select
    Printlcd a$ + "        "
  EndIf
EndIf
Loop Until Touch(x) >= 0
End Sub

Function GetNote$(n)
 If n < 21 Then
  getnote$ = "R"
 Else
   Local i = (n And &h7f) - 21
   Local j = i Mod 12
   Local o = i \ 12
   Local s$ = ""
   If n>127 Then s$ = "-"
   getnote$ = nt$(j) + Str$(o) + s$
 End If
End Function

Sub printlcd a$
  Text 1,lcdy,a$,LT,1,2,col%
  lcdy = lcdy + 31
  If lcdy > 300 Then
    lcdy = 0
    lcdind = lcdind + 1
    If lcdind > 7 Then lcdind = 0
    Select Case lcdind
    Case 0
      col% = RGB(white)
    Case 1
      col% = RGB(255,0,0)
    Case 2
      col% = RGB(0,255,0)
    Case 3
      col% = RGB(0,0,255)
    Case 4
      col% = RGB(255,255,0)
    Case 5
      col% = RGB(0,255,255)
    Case 6
      col% = RGB(255,0,255)
    Case 7
      col% = RGB(180,220,255)
    End Select
  EndIf
End Sub

Sub MidiButtons
  If settings$ = "" Then
    bttxt$(0,0) = "Edit"
    bttxt$(6,0) = "Colour"
    bttxt$(12,0) = "Save"
    bttxt$(18,0) = "Quit"
  Else
    Local a$, c$, p
    p = 0
    a$ = ""
    For i = 1 To Len(settings$)
      c$ = Mid$(settings$,i,1)
      If c$="," Then
        If p < 23 Then bttxt$(p,0) = a$
        a$ = ""
        p = p + 1
      Else
        a$ = a$ + c$
      EndIf
    Next i
  EndIf
  DrawButtons 0
  Local t = 0, k = 0
  Local col = 0
  Local m$ = ""
  Do
  If Touch(x)>=0 Then
    k = GetKey()
    Select Case k
    Case 0
      m$=GetMsg$()
      DrawButtons 0
      t = getkey()
      If t Mod 6 > 0 Then
        bttxt$(t,0)=m$
        DrawButtons 0
      EndIf
    Case 6
      col = GetCol()
      DrawButtons 0
      t = GetKey()
      btcol%(t,0)=btcol%(col,1)
      DrawButtons 0
    Case 12
      settings$ = ""
      For i = 0 To 23
        settings$ = settings$ + bttxt$(i,0) + ","
      Next i
      VAR save settings$, btcol%()
    Case 18
      'quit
    Case Else
      SendMidi bttxt$(k,0)
    End Select
  Else
    If Loc(#1) > 0 Then
      a$=Input$(1,#1)
      MidiOut a$
    EndIf
  EndIf
  Loop Until k = 18
End Sub

Sub DrawButtons st
  CLS
  win = st
  For i = 0 To 23: btn(i): Next i
End Sub

Sub Btn i
  Local x = i Mod 6
  Local y = i \ 6
  Local ts = 1
  If win=2 Or (win=3 And i Mod 6 > 1) Then ts=2
  Local bk% = btcol%(i,win)
  If selected = i Then bk% = RGB(black)
  Box x*80,y*80,77,77,2,btcol%(i,win),bk%
  Text x*80+40,y*80+40,bttxt$(i+more,win),CM,1,ts,RGB(black),btcol%(i,win)
End Sub

Function GetKey()
  Local t = 0, gk, col%
  Do
    t = checktouch()
    Pause 5
    If selected >= 0 Then
      If Loc(#1) > 0 Then GetMidiNote
    EndIf
  Loop Until t >=0
  col% = btcol%(t,win)
  btcol%(t,win) = RGB(black)
  If win <> 3 Or t Mod 6 < 2 Then Btn t
  gk = t
  Local ct = 0
  Do
    t = CheckTouch()
    If t < 0 Then
      ct = ct + 1
      Pause 5
    Else
      ct = 0
    EndIf
  Loop Until ct > 5
  btcol%(gk,win) = col%
  If win <> 3 Or gk Mod 6 < 2 Then Btn gk
'  Print "GetKey " gk
  GetKey = gk
End Function

Function CheckTouch()
  x=Touch(x): y=Touch(y)
  Local x1 = 0: y1 = 0: hit = -1
  i = 0
  Do
    x1 = (i Mod 6) * 80
    y1 = (i \ 6) * 80
    If x>x1 And x<x1+78 And y>y1 And y<y1+78 Then hit = i
    i = i + 1
  Loop While hit < 0 And i < 24
  CheckTouch = hit
End Function

Function GetCol()
  DrawButtons 1
  getcol = GetKey()
End Function

Function GetMsg$()
  DrawButtons 2
  Local m$ = ""
  Local t = 0
  Do
    t = getkey()
    If t Mod 6 < 4 Then
      If Len(m$) < 6) Then m$ = m$ + bttxt$(t,2)
    Else
      If t = 22 And Len(m$) > 0 Then
        m$ = Left$(m$,Len(m$)-1)
      EndIf
    EndIf
    Text 330,2,Left$(m$+"      ",6),LT,1,2,RGB(white),RGB(blue)
  Loop Until t = 23
  getmsg$=m$
End Function

Sub SendMidi midi$
  Print "Send MIDI " + midi$
  Local c,a$
  For i = 1 To Len(midi$) Step 2
    a$ = Mid$(midi$,i,1)
    If Len(midi$) > i Then a$ = a$ + Mid$(midi$,i+1,1)
    c = Val("&H" + a$)
    MidiOut Chr$(c)
  Next i
End Sub

Sub MidiSeq
  Local x,y,tempo
  bttxt$(0,3) = "Slower"
  bttxt$(1,3) = "Faster"
  bttxt$(6,3) = "Next"
  bttxt$(7,3) = "Down"
  bttxt$(12,3) = "Record"
  bttxt$(13,3) = "Stop/Play"
  bttxt$(19,3) = "More"
  bttxt$(18,3) = "Quit"
  bttxt$(2,3) = "Layer 0"
  bttxt$(3,3) = "Clear"
  bttxt$(8,3) = "Vel-Flat"
  bttxt$(9,3) = "Arp-Off"
  bttxt$(14,3) = "Chan-"
  bttxt$(15,3) = "Chan+"
  bttxt$(21,3) = "Back"
  bttxt$(20,3) = "Quit"

  vp=0
  velocity=127
  layer=0
  channel=1
  more = 0
  win = 3
  tempo = 60
  play=0 'stopped
  For i = 0 To 23
    btcol%(i,3) = RGB(160,160,160)
    If i Mod 6 < 2 Then btn(i)
  Next i
  UpdateSeqButtons
  GetSeqLength

  Local t = 0, k = 0
  Local col = 0
  Local m$ = ""
  Local ls
  sel = 0
  x = sel Mod 16
  y = sel \ 16
  Box x*40+160,y*40,39,39,2,RGB(white),NoteCol%(sel)
  t = Timer
  Do
    k = GetKey()
    Select Case k
    Case 0 'tempo -
      If more = 0 Then
        If Timer - t > 500 Then
          tempo = tempo - 1
        Else
          tempo = tempo * 0.9
        EndIf
        t = Timer
        If tempo < 20 Then tempo = 20
        SetBeat tempo
      Else 'Layer
        layer = layer+1
        If layer>2 Then layer=0
        bttxt$(2,3)="Layer " + Str$(layer)
        Btn 0
        channel = laychan(layer)
        bttxt$(14,3) = "Chan-" + Str$(channel)
        btn 12
        Print "Layer " layer " channel " channel
        UpdateSeqButtons
      EndIf
    Case 1 'tempo +
      If more = 0 Then
        If Timer - t > 500 Then
          tempo = tempo + 1
        Else
          tempo = tempo*1.1
        End If
        t = Timer
        If tempo > 800 Then tempo = 800
        Print tempo
        SetBeat tempo
      Else 'clear
        a$ = ""
        For i = 1 To 192
          a$ = a$+Chr$(1)
        Next i
        seq$(layer)=a$
        sel = 0
        UpdateSeqButtons
        x = sel Mod 8
        y = sel \8
        Box x*40+160,y*40,39,39,2,RGB(white),NoteCol%(sel)
      EndIf
    Case 6 'next
      If more = 0 Then
        Box x*40+160,y*40,39,39,2,RGB(black),NoteCol%(sel)
        sel = sel + 1
        If sel>63 Then sel = 0
        x = sel Mod 8
        y = sel \8
        Box x*40+160,y*40,39,39,2,RGB(white),NoteCol%(sel)
      Else 'velocity
        Select Case vp
        Case 0
          vp=1
          bttxt$(8,3)="Vel-Fast"
          velocity=127
        Case 1
          vp=2
          bttxt$(8,3)="Vel-Slow"
        Case 2
          vp=0
          bttxt$(8,3)="Vel-Flat"
        End Select
        Btn 6
        Print "Velocity Profile:" vp
      EndIf
    Case 7 'down
      If more = 0 Then
        Box x*40+160,y*40,39,39,2,RGB(black),NoteCol%(sel)
        sel = sel + 8
        If sel>63 Then sel=sel - 64
        x = sel Mod 8
        y = sel \8
        Box x*40+160,y*40,39,39,2,RGB(white),NoteCol%(sel)
      Else 'arp
        arp = arp+1
        If arp>6 Then arp = 0
        Select Case arp
        Case 0
          bttxt$(9,3)="Arp-Off"
        Case 1
          bttxt$(9,3)="Arp-123"
        Case 2
          bttxt$(9,3)="Arp-132"
        Case 3
          bttxt$(9,3)="Arp-213"
        Case 4
          bttxt$(9,3)="Arp-231"
        Case 5
          bttxt$(9,3)="Arp-312"
        Case 6
          bttxt$(9,3)="Arp-321"
        End Select
        Btn 7
      EndIf
    Case 12 'record
      If more = 0 Then
        play = 0
        SetTick 0,0
        Record
      Else 'Chan-
        channel = channel - 1
        If channel < 0 Then channel = 15
        bttxt$(14,3) = "Chan-" + Str$(channel)
        Btn 12
        laychan(layer)=channel
      EndIf
    Case 13 'Stop/Play
      If more = 0 Then
        If play = 0 Then
          sel = seqlength
          play=1
          Print "Play"
          MidiOut Chr$(&hfa)
          x = sel Mod 8
          y = sel \ 8
          Box x*40+160,y*40,39,39,2,RGB(black),NoteCol%(sel)
          SetBeat tempo
        Else
          play = 0
          x = sel
          If x = 0 Then x=63
          EndNote Asc(Mid$(seq$(layer),x,1))
          Print "Stop"
          MidiOut Chr$(&hfb)
          SetTick 0,0
        EndIf
      Else 'chan+
        channel = channel + 1
        If channel > 15 Then channel = 0
        bttxt$(14,3) = "Chan-" + Str$(channel)
        Btn 12
        laychan(layer)=channel
      EndIf
    Case 19 'more
      If more = 0 Then
        more = 2
      Else
        more = 0
      EndIf
      For i = 0 To 23
        If i Mod 6 < 2 Then btn(i)
      Next i
    Case 18 'quit
      If play = 1 Then
        play = 0
        x = sel
        If x = 0 Then x=63
        EndNote Asc(Mid$(seq$(layer),x,1))
        SetTick 0,0
      EndIf
      VAR save seq$()
      VAR save laychan()
      Exit Sub
    Case Else
      Box x*40+160,y*40,39,39,2,RGB(black),NoteCol%(sel)
      x = ((k Mod 6) - 2) * 2
      y = (k \ 6) * 2
      sel = y * 8 + x
      Box x*40+160,y*40,39,39,2,RGB(white),NoteCol%(sel)
    End Select
  Loop Until k = 18
  selected = -1
End Sub

Sub UpdateSeqButtons
  For i = 0 To 63
    x = i Mod 8
    y = i \ 8
    Box x*40+160,y*40,39,39,2,RGB(black),NoteCol%(i)
  Next i
End Sub

Function NoteCol%(i)
  If i > 63 Then
    NoteCol%=0
  Else
    Local x = Asc(Mid$(seq$(layer),i*3+1,1))
    Local a = ((x >> 5) And 3) << 6
    If a > 255 Then a = 255
    Local b = ((x >> 2) And 7) << 5
    If b > 255 Then b = 255
    Local c = (x And 3) << 6
    If c > 255 Then c = 255
    NoteCol%=RGB(b,c,a)
  EndIf
End Function

Sub GetMidiNote
  Local d$,c$="", cmd, nt, vel
  If Loc(#1)>2 Then
    d$=Input$(3,#1)
    MidiOut d$
    cmd = Asc(Mid$(d$,1,1))
    nt = Asc(Mid$(d$,2,1))
    vel = Asc(Mid$(d$,3,1))
    If (cmd >> 4) = 9 And vel <> 0 Then
      c$=getnote$(nt)
    EndIf
  EndIf
  If c$<>"" Then
    bttxt$(selected,3)=c$
    Btn selected
  EndIf
End Sub

Sub SetBeat temp
  Local p = 1000 / (temp / 60 * 24)
  Print "Set tempo " temp " BPM, Period " p " ms"
  bc = 0
  SetTick p,Beat
End Sub

Sub Record
  'Print "Recording started"
  Local d$, ch, a$, b$, x, y, note, t, n2, n3, l1, l2, rel, j, n
  a$ = seq$(layer)
  note = 1: n2 = 1: n3 = 1
  velocity = 50
  t = Timer
  Box x*40+160,y*40,39,39,1,RGB(white),NoteCol%(sel)
  Do
    If Loc(#1)>1 Then
      Pause 100 'wait for all keys to come in
      d$=Input$(Loc(#1),#1)
      l1 = Len(d$)
      Print l1
      MidiOut d$
      l2 = 1
      rel = 0
      Do
        i = Asc(Mid$(d$,l2,1)) >> 4
        ch = Asc(Mid$(d$,l2,1)) And &hf
        If i = 9 Or i = 8 Then 'keydown
          Select Case l2
          Case 1
            note = Asc(Mid$(d$,l2+1,1))
          Case 4
            n2 = Asc(Mid$(d$,l2+1,1))
          Case 7
            n3 = Asc(Mid$(d$,l2+1,1))
          End Select
          If note > n2 And n2 <> 1 Then
            x = note: note = n2: n2 = x
          EndIf
          If note > n3 And n3 <> 1 Then
            x = note: note = n3: n3 = x
          EndIf
          If n2 > n3 And n3<> 1 Then
            x = n2: n2 = n3: n3 = x
          EndIf
          If Asc(Mid$(d$,l2+2,1)) = 0 Or i = 8 Then '0 velocity, kill notes
            note = note And &h7f 'remove tie from previous note
            n2 = n2 And &h7f
            n3 = n3 And &h7f
            b$ = Chr$(note) + Chr$(n2) + Chr$(n3)
            i = sel - 1
            If i < 0 Then i = 63
            a$ = Left$(seq$(layer),i*3)+b$+Mid$(seq$(layer),i*3+4)
'            seq$(layer)=a$
            note = 1:n2 = 1:n3 = 1
            rel = 1
          End If
          l2 = l2 + 3
        EndIf
      Loop Until l2 >= l1
      If rel = 0 Then
        Print "Note " Hex$(note);getnote$(note),Hex$(n2);getnote$(n2),getnote$(n3)
        b$=Chr$(note)+Chr$(n2)+Chr$(n3)
        a$ = Left$(seq$(layer),sel*3)+b$+Mid$(seq$(layer),sel*3+4)
        seq$(layer) = a$
        x = sel Mod 8
        y = sel \ 8
        Box x*40+160,y*40,39,39,1,RGB(red),NoteCol%(sel)
        sel = sel + 1
        If sel > 63 Then sel = 0
        For j = 0 To 2
          If empty(j) = 0 And layer <>j Then
            n = Asc(Mid$(seq$(j),sel*3+1,1))
            If n<>1 Then playnote n,1,laychan(j)
          EndIf
        Next j
        x = sel Mod 8
        y = sel \ 8
        Box x*40+160,y*40,39,39,1,RGB(white),NoteCol%(sel)
        t = Timer
      EndIf
    EndIf
    If Timer - t > 1000 Then
      Print "Timeout " getnote$(note), getnote$(n2),getnote$(n3)
      If note <> 1 Then
        note = note Or &h80
        If n2 > 1 Then n2 = n2 Or &h80
        If n3 > 1 Then n3 = n3 Or &h80
        i = sel - 1
        If i < 0 Then i = 63
        b$=Chr$(note)+Chr$(n2)+Chr$(n3)
        a$ = Left$(seq$(layer),i*3)+b$+Mid$(seq$(layer), i*3+4)
        seq$(layer)=a$
      End If
      d$=Chr$(note)+Chr$(n2)+Chr$(n3)
      a$ = Left$(seq$(layer),sel*3)+d$+Mid$(seq$(layer),sel*3+4)
      seq$(layer) = a$
      x = sel Mod 8
      y = sel \ 8
      Box x*40+160,y*40,39,39,1,RGB(red),NoteCol%(sel)
      sel = sel + 1
      If sel > 63 Then sel = 0
      x = sel Mod 8
      y = sel \ 8
      Box x*40+160,y*40,39,39,1,RGB(white),NoteCol%(sel)
      t = Timer
    End If
  Loop While Touch(x) < 0
 ' Print "Recording stopped"
  t = getkey()
  UpdateSeqButtons
  GetSeqLength
  For i = 1 To 192
    Print Hex$(Asc(Mid$(seq$(layer),i,1)));" ";
  Next i
End Sub

Sub GetSeqLength
  seqlength = 63
  i = 63
  Local x,y,z,i
  Local f
  empty(0)=1:empty(1)=1:empty(2)=1
  Do
    x = Asc(Mid$(seq$(0),seqlength*3+1,1))
    y = Asc(Mid$(seq$(1),seqlength*3+1,1))
    z = Asc(Mid$(seq$(2),seqlength*3+1,1))
    f= x+y+z
    If f = 3 Then seqlength = seqlength - 1
  Loop While f=3 And seqlength > 0
  For i = 0 To 63
    x = Asc(Mid$(seq$(0),i*3+1,1))
    If x <> 1 Then empty(0)=0
    y = Asc(Mid$(seq$(1),i*3+1,1))
    If y <> 1 Then empty(1)=0
    z = Asc(Mid$(seq$(2),i*3+1,1))
    If z <> 1 Then empty(2)=0
  Next i
  seqlength = seqlength + 1
  Print "Seq length: " seqlength " Empty " empty(0) empty(1) empty(2)
End Sub

Sub PlayNote n,a,ch
'Print "Playnote " n " channel " ch " vel " velocity
  If n < 21 Then
    If a=1 Then EndNote n,ch
    Exit Sub
  EndIf
  Local nt = n And &h7f
  MidiOut Chr$(&h90 Or ch)+Chr$(nt)+Chr$(velocity)
  If ch = channel Then
    Local f = 2^((nt-49)/12)*440
    PWM 1,f,50
    updateanalog nt
  EndIf
End Sub

Sub EndNote n,ch
  If n = 1 Then Exit Sub
  MidiOut Chr$(&h90 Or ch)+Chr$(n)+Chr$(0)
  PWM 1,440,0
  Pin(9)=1
  Pin(10)=1
End Sub

Sub Keyboard
  For i = 0 To 8
    Box i*60,160,78,159,2,RGB(black),RGB(white)
  Next i
  For i = 0 To 1
    Box i*60+35,160,48,80,0,RGB(black),RGB(black)
  Next i
  For i = 0 To 2
    Box i*60+215,160,48,80,0,RGB(black),RGB(black)
  Next i
  Box 0,0,80,60,2,RGB(black),RGB(white)
  Box 80,0,80,60,2,RGB(black),RGB(white)
  Box 240,0,80,60,2,RGB(black),RGB(white)
  Box 320,0,80,60,2,RGB(black),RGB(white)
  Text 40,30,"Oct Down",CM,1,1,RGB(black),RGB(white)
  Text 120,30,"Oct Up",CM,1,1,RGB(black),RGB(white)
  Text 280,30,Str$(channel),CM,1,1,RGB(black),RGB(white)
  Text 360,30,"Quit",CM,1,1,RGB(black),RGB(white)
  velocity = 127
  Local x, y, p, sn
  sn = 60
  Do
    x = Touch(x)
    y = Touch(y)
    If x >=0 And y>=0 Then
    If y < 60 Then
      If x<80 Then
        If sn>24 Then sn=sn-12
        Box 0,0,80,60,2,RGB(black),RGB(80,80,80)
        Print "Oct down C="sn
        WaitTouchUp
        Box 0,0,80,60,2,RGB(black),RGB(white)
        Text 40,30,"Oct Down",CM,1,1,RGB(black),RGB(white)
      ElseIf x<160 Then
        If sn<109 Then sn=sn+12
        Box 80,0,80,60,2,RGB(black),RGB(80,80,80)
        WaitTouchUp
        Print "Oct up C="sn
        Box 80,0,80,60,2,RGB(black),RGB(white)
        Text 120,30,"Oct Up",CM,1,1,RGB(black),RGB(white)
      ElseIf x>240 And x<320 Then
        channel = channel + 1
        If channel > 15 Then channel = 0
        Box 240,0,80,60,2,RGB(black),RGB(80,80,80)
        WaitTouchUp
        Print "Channel="channel
        Box 240,0,80,60,2,RGB(black),RGB(white)
        Text 280,30,Str$(channel),CM,1,1,RGB(black),RGB(white)
      ElseIf x>320 And x<400 Then
        Print "Quit"
        WaitTouchUp
        Exit Sub
      EndIf
    EndIf
    If y>160 Then
      If y>240 Then
        p = Int(x / 60)
        n=whitenote(p)
        Box 60*p+2,240,58,77,0,RGB(180,180,180),RGB(180,180,180)
        playnote n+sn,1,channel
      Else
        p = 0
        n = 0
        If x>35 And x<85 Then
          p = 35
          n = 1
        ElseIf x>95 And x<145 Then
          p =95
          n = 3
        ElseIf x>215 And x<255 Then
          p=215
          n=6
        ElseIf x>275 And x<315 Then
          p =275
          n = 8
        ElseIf x>335 And x<385 Then
          p=335
          n=10
        EndIf
        If p > 0 Then
          playnote n+sn,1,channel
          Box p,160,48,80,0,RGB(180,180,180),RGB(180,180,180)
        EndIf
      EndIf
      WaitTouchUp
      If y>240 Then
        EndNote n+sn
        Box 60*p+2,240,58,77,0,RGB(white),RGB(white)
      Else
        If p>0 Then
          EndNote n+sn
          Box p,160,48,80,0,RGB(black),RGB(black)
        EndIf
      EndIf
    EndIf
    EndIf
  Loop
End Sub

Sub WaitTouchUp
Local c = 0
  Do
    c = c + 1
    If Touch(x) >= 0 Then c = 0
    Pause 10
  Loop Until c > 10
End Sub

Sub UpdateAnalog n
  Local d = Int((n-24)/12*20)
  If d < 0 Then d = 0
  If d > 100 Then d=100
'  Print "Update analog " n,"Duty% "d
  Pin(9)=0 'gate high - run through inverter
  Pin(10)=0 'trigger high
  Pause 1
  Pin(10)=1
  PWM 2,50000,d
End Sub

Sub MidiOut o$
  Print #1,o$;
  Local i,j
  For i = 1 To Len(o$)
    j = Asc(Mid$(o$,i,1))
    If (j And &hf0) <> &hF0 Then Print Hex$(j);" ";
  Next i
End Sub

Sub Beat
  MidiOut Chr$(&hf8)
  bc = (bc + 1) Mod 24
  Local i = 1, j,n
  velocity = 127
  Select Case vp
  Case 1
    velocity = (sel Mod 3 + 1) * 42 + 1
  Case 2
    velocity = (sel Mod 6 + 1) * 21 + 1
  End Select
  If bc = 0 And seqlength>0 Then
    Local c% = RGB(white)
    Box 110,220,10,10,0,RGB(black),c%
    Local x = sel Mod 8
    Local y = sel \ 8
    Box x*40+160,y*40,39,39,2,RGB(black),NoteCol%(sel)
    sel = sel + 1
    If sel >= seqlength Then sel = 0
    i = 1
    If arp = 3 Or arp = 4 Then i = 2
    If arp = 5 Or arp = 6 Then i = 3
    For j = 0 To 2
      If empty(j) = 0 Then
        n = Asc(Mid$(seq$(j),sel*3+i,1))
        If n<>1 Then playnote n,1,laychan(j)
      EndIf
    Next j
    x = sel Mod 8
    y = sel \ 8
    Box x*40+160,y*40,39,39,2,c%,NoteCol%(sel)
  EndIf
  If bc = 8 And arp<>0 Then
    i = 2
    If arp = 2 Or arp = 4 Then i = 3
    If arp = 3 Or arp = 5 Then i = 1
    For j = 0 To 2
      If empty(j) = 0 Then
        n =Asc(Mid$(seq$(j),sel*3+2,1))
        playnote n,0,laychan(j)
      EndIf
    Next j
  EndIf
  If bc = 12 Then
    Box 110,220,10,10,0,RGB(black),RGB(black)
  EndIf
  If bc = 16 And arp<>0 Then
    i = 3
    If arp = 2 Or arp = 5 Then i = 2
    If arp = 4 Or arp = 6 Then i = 1
    For j = 0 To 2
      If empty(j)=0 Then
        n = Asc(Mid$(seq$(j),sel*3+3),1)
        playnote n,0,laychan(j)
      EndIf
    Next j
  EndIf
  If bc = 22 Then
    For j = 0 To 2
      i= Asc(Mid$(seq$(j),sel*3 + 1,1))
      If (j And &h80) = 0 Then endnote i,j
    Next j
  EndIf
End Sub                                       